#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../common/cancel_appointment'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/feedback'
require_relative '../../pages/landing_notifications'
require_relative '../community_care/cc_SM_request_helper'


describe '[Story: VAR-12341 Appointment List:  Show appointments up to 13 months in the future - Add Pagination control]'  do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    TITLE = "Appointments/Requests"
    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
    @sevenDaysFromNow = getDateNthDaysFromNow(7, "%m/%d/%Y")
    @nintyDaysLater = getDateNthDaysFromNow(90, "%m/%d/%Y")

    #mongo
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteriaOmaha.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    deleteAllCCRequestData
    insertFacilityData


    1.upto(5) do |i|
      requestID = "55009430#{i}"
      ccReqID = "66008#{i}"
      removeDocument("bookedCCAppointments", requestID, @db)
      stage_cc_data_reqst_oracle(ccReqID, requestID)
      documentCCRequestOracle(requestID, "#{MockUser05['userid']}", "636", "test")
      documentDetailcodeOracle("8a82828461b511740161bf87d98b00#{i}f", requestID)
      insertDocument("bookedCCAppointments", documentRequestInMongo(requestID, "#{MockUser05['userid']}" ) , @db)
    end


    @common.loginEndsOnHome(MockUser05)
    @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)

  end

  after(:all) do
    1.upto(10) do |i|
      removeDocument("bookedCCAppointments", "55009430#{i}", @db)
    end
    deleteAllCCRequestData
    @driver.close
  end

  context 'when appointment list is less than Five appointments' do

    it 'Verify Disabled pagination controls when appointments in list are less than or equal to 5 appointments' do
      @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_appointments.pagination_navigation_links_elements.first.attribute("class")).to include("disabled")
    end

    it 'Verify navigate to previous page is disabled when appointments in list are less than or equal to 5 appointments' do
      expect(@landing_appointments.pagination_navigation_links_elements[1].attribute("class")).to include("disabled")
    end

    it 'Verify first page link is disabled when appointments in list are less than or equal to 5 appointments' do
      expect(@landing_appointments.pagination_navigation_links_elements[2].attribute("class")).to include("disabled")
    end

    it 'Verify navigate to next page is disabled when appointments in list are less than or equal to 5 appointments' do
      expect(@landing_appointments.pagination_navigation_links_elements[3].attribute("class")).to include("disabled")
    end

    it 'Verify navigate to last page is disabled when appointments in list are less than or equal to 5 appointments' do
      expect(@landing_appointments.pagination_navigation_links_elements[4].attribute("class")).to include("disabled")
    end

  end

  context 'AC#VAR-13358|TC#VAR-13359: Appointment List:  Show appointments up to 13 months in the future - Add Pagination control' do

    it 'Should verify pagination controls enabled when appointment list is greater than 5' do

      6.upto(10) do |i|
        requestID = "55009430#{i}"
        ccReqID = "66008#{i}"
        removeDocument("bookedCCAppointments", requestID, @db)
        stage_cc_data_reqst_oracle(ccReqID, requestID)
        documentCCRequestOracle(requestID, "#{MockUser05['userid']}", "636", "test")
        documentDetailcodeOracle("8a82828461b511740161bf87d98b00#{i}f", requestID)
        insertDocument("bookedCCAppointments", documentRequestInMongo(requestID, "#{MockUser05['userid']}" ) , @db)
      end
      @landing_appointments.clickRefresh
      @landing_appointments.appointment_header_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing_appointments.pagination_controls_appointments_element.visible?).to eq(true)

    end

    it 'Should verify user can navigate between pages' do
      @common.logoutAndLogbackWithADifferentUser(MockUser05)
      @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_appointments.clickPage("2")
      @common.waitWhileSpinnerPresent
      expect(@landing_appointments.pagination_controls_appointments).to eq("10 found, displaying 6 through 10")
    end

    it 'should verify count of bottom pagination' do
      expect(@landing_appointments.pagination_controls_appointments_bottom).to include("10 found, displaying 6 through 10")
    end

    it 'Should verify user can go to the last page of appointments' do
      b = @landing_appointments.pagination_navigation_elements.last
      b.click
      expect(@landing_appointments.pagination_controls_appointments).to eq("10 found, displaying 6 through 10")
    end

    it 'Should verify once on last page, the navigate to last page control is disabled' do
      expect(@landing_appointments.pagination_navigation_links_elements.last.attribute("class")).to include("disabled")

    end

    it 'Should verify once on last page, the navigate to next page control is disabled' do
      expect(@landing_appointments.pagination_navigation_links_elements[4].attribute("class")).to include("disabled")

    end

    it 'Should verify user can navigate to the first page' do
      @landing_appointments.pagination_navigation_elements.first.click
      expect(@landing_appointments.pagination_controls_appointments).to eq("10 found, displaying 1 through 5")

    end

    it 'Should verify once on the first page, the left navigation controls are disabled' do
      expect(@landing_appointments.pagination_navigation_links_elements.first.attribute("class")).to include("disabled")

    end

    it 'should verify when on first page, go to previous page is disabled' do
      expect(@landing_appointments.pagination_navigation_links_elements[1].attribute("class")).to include("disabled")
    end

    it 'Should verify list count on app refresh' do
      @landing_appointments.clickRefresh
      @common.waitWhileSpinnerPresent
      expect(@landing_appointments.pagination_controls_appointments).to eq("10 found, displaying 1 through 5")
    end

    context 'when appointment list is empty' do

      it 'Verify no pagination is displayed when appointment list is empty' do
        @common.logoutAndLogbackWithADifferentUser(MockUser10)
        @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)
        expect(@landing_appointments.isPaginationDisplayed).to eq(false)
      end

    end
    
  end

end